 ; Ŀ
 ;   Mnx - Rocket Partial menu load.                                       
 ;   Copyright 2002, 2005, 2008 by Rocket Software Ltd.                    
 ;                                                                         
 ; 

 ; Ŀ
 ;   Subroutine Mono - Partial menu Load and Install.                      
 ;   Arguments: Namu, a menu file name (no extension).                     
 ;              Menm, a menu group name.                                   
 ;   Returns nothing, calls nothing.                                       
 ; 
 (DEFUN MONO (namu menm /)
 ; Ŀ
 ;   Unload a menu by the menu group name, not the file name.              
 ;   Loading an already loaded menu hangs the command with an error, so    
 ;   have to unload it first.                                              
 ;   It isn't necessary to reload a partial menu unless it has changed -   
 ;   partial loads are saved between acad sessions.                        
 ; 
  (command "menuunload" menm)      ; by group name in the file, not file name
 ; Ŀ
 ;   Load the partial menu.                                                
 ;   Explicitly using the .mnu extension should force a recompile, or      
 ;   one could just erase the .mns and .mnc files.                         
 ; 
; (command "menuload" (strcat namu ".mnu")) ; use to force a recompile
  (command "menuload" namu)                 ; normal load
 ; Ŀ
 ;   Put the pop sections from the partial menu in front of pop24.         
 ;   Since there is no pop24 in the main file these become the last        
 ;   (furthest right) menus.                                               
 ; 
  (menucmd (strcat "P24=+" menm ".Pop1"))
  (menucmd (strcat "P24=+" menm ".Pop2"))
  (menucmd (strcat "P24=+" menm ".Pop3"))
  (menucmd (strcat "P24=+" menm ".Pop4"))
  (menucmd (strcat "P24=+" menm ".Pop5"))
  (menucmd (strcat "P24=+" menm ".Pop6"))
  (menucmd (strcat "P24=+" menm ".Pop7"))
  (menucmd (strcat "P24=+" menm ".Pop8"))
  (menucmd (strcat "P24=+" menm ".Pop9"))
  (menucmd (strcat "P24=+" menm ".Pop10"))
 (princ))
 ; Ŀ
 ;   Subroutine Mono end.                                                  
 ; 

 ; Ŀ
 ;   Omno - remove the Rocket menu.                                        
 ; 
 (DEFUN C:OMNO (/ menm)
  (setvar "cmdecho" 0)
  (setq menm "Rocket")         ; group name
  (command "menuunload" menm)  ; by group name in the file, not file name
 (princ))

 ; Ŀ
 ;   Mnx.                                                                  
 ; 
 (DEFUN C:MNX (/ namu menm)
  (setvar "cmdecho" 0)
 ; Ŀ
 ;   Typically the menu file name and group name should be the same.       
 ; 
  (setq namu "Rocket")      ; file name
  (setq menm "Rocket")      ; group name
 ; Ŀ
 ;   See if a menu file is available.                                      
 ; 
  (if (or (findfile (strcat namu ".cui"))
          (findfile (strcat namu ".mnu"))
          (findfile (strcat namu ".mns"))
          (findfile (strcat namu ".mnc")))
      (mono namu menm)
      (prompt (strcat "Can't find menu file "
                      (strcase (substr namu 1 1))
                      (strcase (substr namu 2) t) ".")))
 ; Ŀ
 ;   Other stuff you can do.                                               
 ; 
 ; (menucmd "P15.5=~")             ; disable pop15 item 5
 ; (menucmd "P15.5=!")             ; checkmark pop15 item 5
 ; (menucmd "P15.5=")              ; restore pop15 item 5 to base state
 ; (menucmd "p5=-")                ; remove a pop menu
 ; (menucmd "Rocket.pop5=-")       ; doesn't seem to work
 (princ))